/*------------------------------------------------------------------------------*
 * File Name: ImpWizSaveFilters.c												*
 * Creation: 																	*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST				*
 *	Hong 04/10/07 QA80-9595-P2 v8.0697b FIX_FAIL_SAVE_FILTER					*
 *------------------------------------------------------------------------------*/
 

#include <Origin.h>
#include "IWfirst.h"

///Danice 12/25/03 v7.5788 NOTUSE_SHOW
DWORD ImpWizSaveFiltersPage::OnShowStatus(DWORD InternalStatus)
{
	return PSS_Show;
}
///END NOTUSE_SHOW

//Events handles
BOOL ImpWizSaveFiltersPage::OnInit_SaveFilters()		///Jason 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_SAVE_FILTER
	
	///Danice PAGE_INIT_ONCE
	if(!ImpWizardPage::Init())
		return FALSE;
	///END PAGE_INIT_ONCE
	
	///Danice PAGE_INIT_ONCE
	///Danice 2/24/04 v8.0825 PREVENT_INIT_RUN_IN_ASC_AND_BIN
	/*if(bHasInit)
		return true;*/
	///END PREVENT_INIT_RUN_IN_ASC_AND_BIN
	///END PAGE_INIT_ONCE
	//m_page = GetItem(IDD_IW_SAVE_FILTERS);
	m_rbDataFolder = 	GetItem(IDC_SAVE_FILTER_DATA_FOLDER_RADIO);
	m_rbUserFolder = 	GetItem(IDC_SAVE_FILTER_GLOBAL_RADIO);
	m_rbWks = 			GetItem(IDC_SAVE_FILTER_IN_WKS);
	m_ebDescrip = 		GetItem(IDC_FILTER_DESCRIP);
	m_cbName = 			GetItem(IDC_SAVE_FILTERS_NAME_COMBO);
	//m_editWildCard = 	GetItem(IDC_SAVE_FILTERS_APPLICABILITY_EDIT);
	m_chkAdvOptions = 	GetItem(IDC_SAVE_FILTERS_ADVANCED);
	m_chkSaveFilter = 	GetItem(IDC_SAVE_FILTER);
	//m_comboName = 		GetItem(IDC_SAVE_FILTERS_NAME_COMBO);
	m_editFileSpec = 	GetItem(IDC_SAVE_FILTERS_APPLICABILITY_EDIT);
	m_ebDataFolder = 	GetItem(IDC_SAVE_FILTER_DATA_PATH);
	m_ebUserFilesFolder = GetItem(IDC_SAVE_FILTER_USER_PATH);
	//m_cbFilters = 		GetItem(IDC_SAVE_FILTERS_NAME_COMBO);

	m_chkShowFilter =	GetItem(IDC_SAVE_FILTERS_OPEN_LIST); // Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST
	
	//bHasInit = true;	///Danice 2/24/04 v8.0825 PREVENT_INIT_RUN_IN_ASC_AND_BIN	///Danice PAGE_INIT_ONCE
	return TRUE;
}

BOOL ImpWizSaveFiltersPage::OnActive_SaveFilters()	///Jason 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_SAVE_FILTER
	SaveFilters_UpdateData(); // tree to dlg
	SaveFilters_EnableControls();
	SaveFilter_UpdateFilterComboBox();
	SaveFilter_UpdateButtons();
	return TRUE;
}

BOOL ImpWizSaveFiltersPage::OnKillActive_SaveFilters()	///Jason 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_SAVE_FILTER
	SaveFilters_UpdateData(FALSE); // FALSE = dlg to tree
	
	///Danice 12/22/03 v7.5784 ENABLE_NEXT_BUTTON
	m_pSheet->EnableNextBT(1);
	///END ENABLE_NEXT_BUTTON
	return TRUE;
}

BOOL ImpWizSaveFiltersPage::OnClickSaveFilter_SaveFilters(Control ctrl)	///Jason 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME
{
	Button chkSaveFilter(ctrl);
	if( chkSaveFilter.Check )
		ENABLE_SAVE_FILTER;
	else
		DISABLE_SAVE_FILTER;
	SaveFilters_EnableControls();
	SaveFilter_UpdateButtons();
	return TRUE;
}

BOOL ImpWizSaveFiltersPage::OnClickAdvanced_SaveFilters(Control ctrl)	///Jason 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME
{
	Button chkAdvOptions(ctrl);
	if( chkAdvOptions.Check )
		ENABLE_ADVOPTIONS_ISCHECKED;
	else
		DISABLE_ADVOPTIONS_ISCHECKED;
	SaveFilter_UpdateButtons();
	return TRUE;
}

BOOL ImpWizSaveFiltersPage::OnClickDestination_SaveFilters(Control ctrl)	///Jason 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME
{
	///Jason 12/12/03 v7.5780 MOVE_TO_ON_INIT_SAVE_FILTERS
	//Control page = ImportWizDlg.GetItem(IDD_IW_SAVE_FILTERS);
	/// EJP 07-16-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
	//s_iSaveFilter = page.GetCheckedRadioButton(IDC_SAVE_FILTER_DATA_FOLDER_RADIO, IDC_SAVE_FILTER_GLOBAL_RADIO);
	m_pSheet->SaveFilter(GetCheckedRadioButton(IDC_SAVE_FILTER_DATA_FOLDER_RADIO, IDC_SAVE_FILTER_IN_WKS));
	/// end SAVE_FILTER_IN_WKS
	///End MOVE_TO_ON_INIT_SAVE_FILTERS
	
	SaveFilter_UpdateFilterComboBox();

	/// EJP 07-16-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
	SaveFilters_EnableControls();
	SaveFilter_UpdateButtons();
	/// end SAVE_FILTER_IN_WKS
	return TRUE;
}

BOOL ImpWizSaveFiltersPage::OnEditChangeFilterDescription(Control ctrl)
{
	fuSetDescription(s_trFilter, m_ebDescrip.Text);
	return TRUE;
}

BOOL ImpWizSaveFiltersPage::OnSelChangeFilterName_SaveFilter(Control ctrl)	///Jason 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME
{	
	ComboBox comboName(ctrl);
	int n = comboName.GetCurSel();
	string str;
	comboName.GetLBText(n, str);
	comboName.Text = str;
	m_pSheet->SetFilter(str); /// Hong 04/10/07 QA80-9595-P2 v8.0697b FIX_FAIL_SAVE_FILTER
	SaveFilter_UpdateButtons();
	return TRUE;
}

BOOL ImpWizSaveFiltersPage::OnEditChangeFilterName_SaveFilter(Control ctrl)	///Jason 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME
{
	SaveFilter_UpdateButtons();
	/// SY 08/31/2004 v8.0127 QA70-5417.38 SAVE_FILTERS_FAILED
	// because the fliter name is not set on killing focus and is empty, so failed to save filter.
	// temp fix, need Tarak to fix OnKillActive_SaveFilters problem.
	m_pSheet->SetFilter(m_cbName.Text);
	/// end SAVE_FILTERS_FAILED
	return TRUE;
}

BOOL ImpWizSaveFiltersPage::OnChangeFileSpec(Control ctrl)
{
	fuSetFileSpec(IW_FILTER, m_editFileSpec.Text);
	return TRUE;
}

/// Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST
BOOL ImpWizSaveFiltersPage::OnClickShowFilter(Control ctrl)
{
	fuSetShowFilterInOpenList(IW_FILTER, m_chkShowFilter.Check);
	return TRUE;
}
/// end FILTER_SHOW_IN_FILE_OPEN_LIST

void ImpWizSaveFiltersPage::SaveFilters_EnableControls()
{	
	BOOL bEnable = IS_SAVE_FILTER;

	///Jason 12/12/03 v7.5780 MOVE_TO_ON_INIT_SAVE_FILTERS
	//Button rbDataFolder = ImportWizDlg.GetItem(IDC_SAVE_FILTER_DATA_FOLDER_RADIO, IDD_IW_SAVE_FILTERS);
	m_rbDataFolder.Enable = bEnable;
	
	//Button rbUserFolder = ImportWizDlg.GetItem(IDC_SAVE_FILTER_GLOBAL_RADIO, IDD_IW_SAVE_FILTERS);
	m_rbUserFolder.Enable = bEnable;

	/// EJP 07-16-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
	//Button rbWks = ImportWizDlg.GetItem(IDC_SAVE_FILTER_IN_WKS, IDD_IW_SAVE_FILTERS);
	m_rbWks.Enable = bEnable;
	
	BOOL bEnableName = bEnable;
	//if( bEnable && IDC_SAVE_FILTER_IN_WKS == s_iSaveFilter )		///Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_SAVEFILTERS
	if( bEnable && IDC_SAVE_FILTER_IN_WKS == m_pSheet->GetSaveFilter() )	
		bEnableName = FALSE;
	/// end SAVE_FILTER_IN_WKS

	m_chkShowFilter.Enable = bEnable && m_rbUserFolder.Check ? 1:0; // Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST
	
	/// EJP 09-24-2003 v7.5706 QA70-4073.55 ADD_FILTER_DESCRIPTION
	//Edit ebDescrip = ImportWizDlg.GetItem(IDC_FILTER_DESCRIP, IDD_IW_SAVE_FILTERS);
	m_ebDescrip.Enable = bEnableName;
	/// end ADD_FILTER_DESCRIPTION

	//ComboBox cbName = ImportWizDlg.GetItem(IDC_SAVE_FILTERS_NAME_COMBO, IDD_IW_SAVE_FILTERS);
	/// EJP 07-16-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
	///cbName.Enable = bEnable;
	m_cbName.Enable = bEnableName;
	/// end SAVE_FILTER_IN_WKS

	//Edit editWildCard = ImportWizDlg.GetItem(IDC_SAVE_FILTERS_APPLICABILITY_EDIT, IDD_IW_SAVE_FILTERS);
	m_editFileSpec.Enable = bEnable;

	//Button chkAdvOptions = ImportWizDlg.GetItem(IDC_SAVE_FILTERS_ADVANCED, IDD_IW_SAVE_FILTERS);
	m_chkAdvOptions.Enable = bEnable;
	
	///End MOVE_TO_ON_INIT_SAVE_FILTERS
}

BOOL ImpWizSaveFiltersPage::SaveFilters_UpdateData(BOOL bDataToDlg) //=TRUE)
{
	string str;
	///Jason 12/12/03 v7.5780 MOVE_TO_ON_INIT_SAVE_FILTERS
	//Control page = ImportWizDlg.GetItem(IDD_IW_SAVE_FILTERS);
	//Button chkSaveFilter = ImportWizDlg.GetItem(IDC_SAVE_FILTER, IDD_IW_SAVE_FILTERS);
	//ComboBox comboName = ImportWizDlg.GetItem(IDC_SAVE_FILTERS_NAME_COMBO, IDD_IW_SAVE_FILTERS);
	//Edit editFileSpec = ImportWizDlg.GetItem(IDC_SAVE_FILTERS_APPLICABILITY_EDIT, IDD_IW_SAVE_FILTERS);
	//Button chkAdvOptions = ImportWizDlg.GetItem(IDC_SAVE_FILTERS_ADVANCED, IDD_IW_SAVE_FILTERS);

	/// EJP 09-24-2003 v7.5706 QA70-4073.55 ADD_FILTER_DESCRIPTION
	//Edit ebDescrip = ImportWizDlg.GetItem(IDC_FILTER_DESCRIP, IDD_IW_SAVE_FILTERS);
	/// end ADD_FILTER_DESCRIPTION
	///End MOVE_TO_ON_INIT_SAVE_FILTERS
	
	if( bDataToDlg )
	{
		///Jason 12/12/03 v7.5780 MOVE_TO_ON_INIT_SAVE_FILTERS
		/// EJP 07-08-2003 v7.0620 QA70-4792 MAKE_IMPWIZ_UI_MORE_CLEAR
		//Edit ebDataFolder = ImportWizDlg.GetItem(IDC_SAVE_FILTER_DATA_PATH, IDD_IW_SAVE_FILTERS);
		
		m_ebDataFolder.Text = GetFilePath(s_strDataFile);

		str.Format("%s%s", GetAppPath(), FILTERS_FOLDER_NAME);
		//Edit ebUserFilesFolder = ImportWizDlg.GetItem(IDC_SAVE_FILTER_USER_PATH, IDD_IW_SAVE_FILTERS);
		m_ebUserFilesFolder.Text = str;
		///End MOVE_TO_ON_INIT_SAVE_FILTERS
		
		/// EJP 07-18-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
		///// If filter file is from data file path
		///if( 0 == ebDataFolder.Text.CompareNoCase(GetFilePath(s_strFilter)) )
		///	s_iSaveFilter = IDC_SAVE_FILTER_DATA_FOLDER_RADIO;
		///else
		///	s_iSaveFilter = IDC_SAVE_FILTER_GLOBAL_RADIO;
		/// end SAVE_FILTER_IN_WKS
		/// end MAKE_IMPWIZ_UI_MORE_CLEAR

		m_chkSaveFilter.Check = (IS_SAVE_FILTER ? 1 : 0);

		/// EJP 07-16-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
		///page.CheckRadioButton(IDC_SAVE_FILTER_DATA_FOLDER_RADIO, IDC_SAVE_FILTER_GLOBAL_RADIO, s_iSaveFilter);
		//CheckRadioButton(IDC_SAVE_FILTER_DATA_FOLDER_RADIO, IDC_SAVE_FILTER_IN_WKS, s_iSaveFilter);	///Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_SAVEFILTERS
		CheckRadioButton(IDC_SAVE_FILTER_DATA_FOLDER_RADIO, IDC_SAVE_FILTER_IN_WKS, m_pSheet->GetSaveFilter());
		/// end SAVE_FILTER_IN_WKS

		m_cbName.Text = GetFileName(s_strFilter, true); // true=strip file ext
		
		fuGetFileSpec(s_trFilter, str);
		if( str.IsEmpty() )
		{
			str = AIW_GetExtensionFromPath(s_strDataFile);
			fuSetFileSpec(s_trFilter, str);
		}
		m_editFileSpec.Text = str;
	
		m_chkAdvOptions.Check = (IS_ADVOPTIONS_ISCHECKED ? 1 : 0);

		/// EJP 09-24-2003 v7.5706 QA70-4073.55 ADD_FILTER_DESCRIPTION
		if( !fuGetDescription(s_trFilter, str) )
			str.Empty();
		m_ebDescrip.Text = str;
		/// end ADD_FILTER_DESCRIPTION
		
		m_chkShowFilter.Check = fuGetShowFilterInOpenList(s_trFilter); // Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST
	}
	else
	{
		/// EJP 07-16-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
		///s_iSaveFilter = page.GetCheckedRadioButton(IDC_SAVE_FILTER_DATA_FOLDER_RADIO, IDC_SAVE_FILTER_GLOBAL_RADIO);
		/// end SAVE_FILTER_IN_WKS
	
		fuSetFileSpec(s_trFilter, m_editFileSpec.Text);
		//s_strFilter = m_comboName.Text;	///Jason 12/19/03 v7.5781 USE_SHEET_SETFILTER
		m_pSheet->SetFilter(m_cbName.Text);
	
		if( m_chkAdvOptions.Check )
			ENABLE_ADVOPTIONS_ISCHECKED;
		else
			DISABLE_ADVOPTIONS_ISCHECKED;

///		/// EJP 09-24-2003 v7.5706 QA70-4073.55 ADD_FILTER_DESCRIPTION
///		fuSetDescription(s_trFilter, m_ebDescrip.Text);
///		/// end ADD_FILTER_DESCRIPTION
	}
	return TRUE;
}

void ImpWizSaveFiltersPage::SaveFilter_UpdateButtons()
{
	bool bNext, bFinish;

	///Jason 12/12/03 v7.5780 MOVE_TO_ON_INIT_SAVE_FILTERS
	if( IS_SAVE_FILTER )
	{
		//ComboBox cbName = ImportWizDlg.GetItem(IDC_SAVE_FILTERS_NAME_COMBO, IDD_IW_SAVE_FILTERS);
		/// EJP 07-17-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
		//if( IDC_SAVE_FILTER_IN_WKS == s_iSaveFilter )	///Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_SAVEFILTERS
		if( IDC_SAVE_FILTER_IN_WKS == m_pSheet->GetSaveFilter() )
			bFinish = TRUE;
		else
		{
			/// end SAVE_FILTER_IN_WKS
			string str = m_cbName.Text; // copy to string to avoid edit box from entering text backwards
			bFinish = !str.IsEmpty();
		} /// end SAVE_FILTER_IN_WKS
		bNext = (IS_ADVOPTIONS_ISCHECKED && bFinish);
	}
	else
	{
		bNext = false;
		bFinish = true;
	}

	//Button btnNext = ImportWizDlg.GetItem(IDC_NEXT);
	//btnNext.Enable = bNext;
	m_pSheet->EnableNextBT(bNext);

	//Button btnFinish = ImportWizDlg.GetItem(IDC_FINISH);
	//btnFinish.Enable = bFinish;
	m_pSheet->EnableFinishBT(bFinish);
	///End MOVE_TO_ON_INIT_SAVE_FILTERS
}

void ImpWizSaveFiltersPage::SaveFilter_UpdateFilterComboBox()
{
	string strPath;
	//if( IDC_SAVE_FILTER_GLOBAL_RADIO == s_iSaveFilter )	///Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_SAVEFILTERS
	if( IDC_SAVE_FILTER_GLOBAL_RADIO == m_pSheet->GetSaveFilter() )
		strPath.Format("%s%s", GetAppPath(), FILTERS_FOLDER_NAME);
	//else if( IDC_SAVE_FILTER_DATA_FOLDER_RADIO == s_iSaveFilter )	///Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_SAVEFILTERS
	else if( IDC_SAVE_FILTER_DATA_FOLDER_RADIO == m_pSheet->GetSaveFilter() )
		strPath = GetFilePath(s_strDataFile);
	if( !strPath.IsEmpty() )
	{
		///Jason 12/12/03 v7.5780 MOVE_TO_ON_INIT_SAVE_FILTERS
		//ComboBox cbFilters = ImportWizDlg.GetItem(IDC_SAVE_FILTERS_NAME_COMBO, IDD_IW_SAVE_FILTERS);
		///End MOVE_TO_ON_INIT_SAVE_FILTERS
		string str = m_cbName.Text;
		iwFillFilterComboBox(m_cbName, strPath);
		m_cbName.Text = str;
	}
}

string ImpWizSaveFiltersPage::AIW_GetExtensionFromPath(LPCSTR lpcszPath) // return extension in "*.abc" format
{
	string strTemp(lpcszPath);
	strTemp = GetFileName(strTemp); ///---Sim 09-21-2006 FIX_EXTENSION_BUG
	string strFileExtension;
	int nDotPos = strTemp.ReverseFind('.');
	///---Sim 09-21-2006 FIX_EXTENSION_BUG
	//if( nDotPos >= 0 )
	if( nDotPos >= 0 && nDotPos != strTemp.GetLength() - 1 )
	///---END FIX_EXTENSION_BUG
		strFileExtension.Format("*%s", strTemp.Right(strTemp.GetLength() - nDotPos));
	else
		strFileExtension.Empty();
	
	return strFileExtension;
}

void ImpWizSaveFiltersPage::iwFillFilterComboBox(ComboBox& comboFilters, LPCSTR lpcszPath)
{
	comboFilters.ResetContent();

	StringArray saFilterFiles;
	fuGetFilterFiles(saFilterFiles, lpcszPath);
	iwAddFiltersToComboBox(comboFilters, saFilterFiles, -1);
}

void ImpWizSaveFiltersPage::iwAddFiltersToComboBox(ComboBox& comboFilters, StringArray& saFilterFiles, int iFilterLocPrefix)
{
	string str;
	string strFilterLocPrefix;
	if( iFilterLocPrefix >= 0 )
	{
		str = _L("Data Folder|Origin Folder|User Files Folder");
		strFilterLocPrefix = str.GetToken(iFilterLocPrefix, '|');
	}

	for( int i = 0; i < saFilterFiles.GetSize(); i++ )
	{
		if( strFilterLocPrefix.IsEmpty() )
			str = GetFileName(saFilterFiles[i], TRUE);
		else
			str.Format("%s: %s", strFilterLocPrefix, GetFileName(saFilterFiles[i], TRUE));
		comboFilters.AddString(str);
		comboFilters.SetItemData(comboFilters.GetCount() - 1, iFilterLocPrefix);
	}
}

